import { ITcpSocket } from '../../PeerNetwork/Socket/Tcp/ITcpSocket';
import { NodeSocketSerializer } from '../../PeerNetwork/Serializer/NodeSocketSerializer';
import { getLocalAddress as defaultGetLocalAddress } from '../../PeerNetwork/PeerDiscoveryService/PeerDiscoveryService.utils';
import * as tcp from '../../PeerNetwork/Socket/Tcp/tcpSocketFactory';
import { udpSocketFactory as defaultUdpSocketFactory } from '../../PeerNetwork/Socket/Udp/udpSocketFactory';
import { IUdpSocket } from '../../PeerNetwork/Socket/Udp/IUdpSocket';
import { createP2PSynchronizer } from './p2pSynchronizerFactory';

const defaultTcpSocketFactory = (port: number) =>
	tcp.tcpSocketFactory({
		port,
		clientConnectionTimeoutMs: 10e3,
	});

/**
 * Convenience factory to create and instance of P2PSynchronizer for node.js environment.
 */
export function createNodeP2PSynchronizer({
	udpPort,
	tcpPort,
	getDeviceUid,
	getLocalAddress,
	tcpSocketFactory,
	udpSocketFactory,
}: {
	/**
	 * Port for UDP communication
	 * UDP communication is used for network discovery, i.e. to find other devices on the network
	 */
	udpPort?: number;
	/**
	 * Port for TCP communication
	 * TCP communication is used for sending messages between devices
	 */
	tcpPort?: number;
	getDeviceUid: () => Promise<string>;
	getLocalAddress?: () => Promise<string | null>;
	tcpSocketFactory?: (port: number) => Promise<ITcpSocket<Buffer>>;
	udpSocketFactory?: (port: number) => Promise<IUdpSocket<Buffer>>;
}) {
	getLocalAddress = getLocalAddress || defaultGetLocalAddress;
	tcpSocketFactory = tcpSocketFactory || defaultTcpSocketFactory;
	udpSocketFactory = udpSocketFactory || defaultUdpSocketFactory;

	const serializer = new NodeSocketSerializer();

	return createP2PSynchronizer<Buffer>({
		udpPort,
		tcpPort,
		getDeviceUid,
		getLocalAddress,
		tcpSocketFactory,
		udpSocketFactory,
		serializer,
	});
}
