import { ClientSocketSerializer } from '../../PeerNetwork/Serializer/ClientSocketSerializer';
import { ITcpSocket } from '../../PeerNetwork/Socket/Tcp/ITcpSocket';
import { IUdpSocket } from '../../PeerNetwork/Socket/Udp/IUdpSocket';
import { createP2PSynchronizer } from './p2pSynchronizerFactory';

/**
 * Convenience factory to create and instance of P2PSynchronizer for client environment.
 */
export function createClientP2PSynchronizer({
	udpPort,
	tcpPort,
	getDeviceUid,
	getLocalAddress,
	tcpSocketFactory,
	udpSocketFactory,
}: {
	/**
	 * Port for UDP communication
	 * UDP communication is used for network discovery, i.e. to find other devices on the network
	 */
	udpPort?: number;
	/**
	 * Port for TCP communication
	 * TCP communication is used for sending messages between devices
	 */
	tcpPort?: number;
	getDeviceUid: () => Promise<string>;
	getLocalAddress: () => Promise<string | null>;
	tcpSocketFactory: (port: number) => Promise<ITcpSocket<Uint8Array>>;
	udpSocketFactory: (port: number) => Promise<IUdpSocket<Uint8Array>>;
}) {
	const serializer = new ClientSocketSerializer();

	return createP2PSynchronizer({
		udpPort,
		tcpPort,
		getDeviceUid,
		getLocalAddress,
		tcpSocketFactory,
		udpSocketFactory,
		serializer,
	});
}
