export enum BroadcastEvent {
	Value = 'value',
}

export type ValueCallback = (key: string, value: unknown) => void;

/**
 * Used to broadcast values to all devices in the same network.
 */
export interface IBroadcastService {
	broadcastValue(key: string, value: unknown): Promise<void>;
	addListener(event: BroadcastEvent.Value, listener: ValueCallback): void;
	removeListener(event: BroadcastEvent.Value, listener: ValueCallback): void;
}
