import { IStreamOptions, IStreamPrepareOptions } from './IStreamPlayer';

export type StreamEventType = 'connected' | 'disconnected' | 'error' | 'closed' | 'reconnect' | 'tracks_changed';

interface IStreamEvent<T extends StreamEventType> {
	type: T;
	uri: string;
	x: number;
	y: number;
	width: number;
	height: number;
	protocol?: Pick<IStreamOptions, 'protocol'>;

	/**
	 * @deprecated Events should only return protocol
	 */
	options?: IStreamOptions | IStreamPrepareOptions;
}

export default IStreamEvent;
