import { EventEmitter } from 'events';
import {
	IStreamErrorEvent,
	IStreamConnectedEvent,
	IStreamDisconnectedEvent,
	IStreamClosedEvent,
	IStreamTracksChangedEvent,
	IStreamReconnectEvent,
} from './streamEvents';

interface IStream extends EventEmitter {
	on(event: 'error', listener: (event: IStreamErrorEvent) => void): this;
	on(event: 'connected', listener: (event: IStreamConnectedEvent) => void): this;
	on(event: 'disconnected', listener: (event: IStreamDisconnectedEvent) => void): this;
	on(event: 'closed', listener: (event: IStreamClosedEvent) => void): this;
	on(event: 'tracks_changed', listener: (event: IStreamTracksChangedEvent) => void): this;
	on(event: 'reconnect', listener: (event: IStreamReconnectEvent) => void): this;
}

export default IStream;
