export default class MemoryStorage implements Storage {
	[itemKey: string]: any;
	[itemIndex: number]: string;

	public get length() {
		return this.getKeys().length;
	}

	public clear() {
		for (let key of this.getKeys()) {
			this.removeItem(key);
		}
	}

	public getItem(key: string) {
		return typeof this[key] !== 'undefined' ? this[key] : null;
	}

	public removeItem(key: string) {
		delete this[key];
	}

	public setItem(key: string, data: string) {
		this[key] = '' + data;
	}

	public key(index: number) {
		return this.getKeys()[index];
	}

	private getKeys() {
		return Object.keys(this);
	}
}
