import IAction from '@signageos/actions/dist/IAction';
import { ActiveAppletDispatchCommand, AppletPing } from '@signageos/actions/dist/Applet/activeAppletActions';
import { EmitVideoEvent } from '../Front/Applet/Video/EmitVideoEvent';
import { BindAction, CheckSocketHealth, UnbindAction } from './socketActions';
import { UpdateActiveAppletBinary, UpdateActiveAppletBinaryFile } from '@signageos/actions/dist/Applet/appletActions';
import { CheckDeviceConfiguration } from '../Device/Configuration/deviceConfigurationActions';
import {
	ActiveAppletVideoPause,
	ActiveAppletVideoPlay,
	ActiveAppletVideoPrepare,
	ActiveAppletVideoResume,
	ActiveAppletVideoStop,
} from '../Front/Applet/Video/appletVideoActions';
import { RequestDIContainer, UpdateDIContainer, UpdateDIDependency } from '../DI/dependenciesActions';
import { DeviceAlive, SaveOfflineAction } from '../Offline/offlineActions';
import { SystemLog } from '@signageos/actions/dist/SystemLog/systemLogActions';
import { HandleKeySequence, HandleKeyUp } from '@signageos/actions/dist/Input/keyActions';
import { StreamConnected, StreamDisconnected } from '../Stream/streamActions';
import { HandleMotion, HandleMotionSequence } from '@signageos/actions/dist/Input/motionActions';
import { UpdateDisplayFirmwareVersion } from '../Front/Device/deviceActions';

const EXCLUDED_DELIVERY_TO_SERVER_ACTIONS = [
	AppletPing,
	BindAction,
	UnbindAction,
	CheckSocketHealth,
	ActiveAppletVideoPlay,
	ActiveAppletVideoPrepare,
	ActiveAppletVideoStop,
	ActiveAppletVideoPause,
	ActiveAppletVideoResume,
	EmitVideoEvent,
	UpdateActiveAppletBinary,
	UpdateActiveAppletBinaryFile,
	CheckDeviceConfiguration,
	UpdateDIDependency,
	UpdateDIContainer,
	RequestDIContainer,
	SaveOfflineAction,
	DeviceAlive,
	HandleKeySequence,
	HandleKeyUp,
	HandleMotion,
	HandleMotionSequence,
	StreamConnected,
	StreamDisconnected,
	UpdateDisplayFirmwareVersion,
];

export function shouldBeSentToServer(action: IAction<string>) {
	return !EXCLUDED_DELIVERY_TO_SERVER_ACTIONS.includes(action.type);
}

const EXCLUDED_FROM_FAST_OFFLINE_BUFFER = [ActiveAppletDispatchCommand, SystemLog];

export function shouldBeAddedToFastOfflineBuffer(action: IAction<string>) {
	return !EXCLUDED_FROM_FAST_OFFLINE_BUFFER.includes(action.type);
}
