import Property from './Property';
import { IPropertyStorage } from './propertyStorage';

export function createMemoryPropertyStorage() {
	const memoryStorage: { [key: string]: any } = {};
	const propertyStorage: IPropertyStorage = {
		async getValueOrDefault<TValue>(key: Property, defaultValue: TValue): Promise<TValue> {
			return memoryStorage[key] ?? defaultValue;
		},
		async setValue<TValue>(key: string, value: TValue): Promise<void> {
			memoryStorage[key] = value;
		},
		async removeValue(key: string): Promise<void> {
			delete memoryStorage[key];
		},
	};
	return propertyStorage;
}
