import { ISerializer, parseMessage } from './serialization';
import { Buffer } from 'buffer';

export class ClientSocketSerializer implements ISerializer<Uint8Array> {
	public serialize(message: object): Uint8Array {
		const encodedMessage = JSON.stringify(message);
		return Buffer.from(encodedMessage);
	}

	public deserialize(messageBuffer: Uint8Array): object | null {
		const messageString = Buffer.from(messageBuffer).toString('utf-8');
		return parseMessage(messageString);
	}
}
