export interface PeerDiscoveryPeer {
	id: string;
	aliveAt: Date;
	address: string;
	port: number;
}

export enum PeerDiscoveryServiceEvent {
	PeersChanged = 'peers_changed',
}

export type PeersChangedCallback = () => void;

/**
 * Handles discovery of other peers in the network and communication with them.
 */
export interface IPeerDiscoveryService {
	start(): Promise<void>;
	stop(): Promise<void>;
	isStarted(): boolean;
	/** Get my information as a peer in the network */
	getMe(): Omit<PeerDiscoveryPeer, 'address' | 'port'>;
	/** Get list of all discovered peers (not myself) */
	getPeers(): PeerDiscoveryPeer[];
	addListener(event: PeerDiscoveryServiceEvent.PeersChanged, callback: PeersChangedCallback): void;
}
