import ZoneOffset from './ZoneOffset';

export type TimeManagerFinalizeCallback = (() => Promise<void>) | void;

export default interface ITimeManager {
	getEpochMillis(): Promise<number>;
	getZoneOffset(): Promise<ZoneOffset>;
	canGetZoneId(): Promise<boolean>;
	getZoneId(): Promise<string>;
	canGetNtpServer(): Promise<boolean>;
	getNtpServer(): Promise<string | null>;
	canSetManual(): Promise<boolean>;
	setManual(epochMillis: number, zone: string): Promise<TimeManagerFinalizeCallback>;
	canSetAuto(): Promise<boolean>;
	setAuto(ntpServer: string, zone: string): Promise<TimeManagerFinalizeCallback>;
	isAutoEnabled(): Promise<boolean>;
}
