import ITimeManager from './ITimeManager';
import ZoneOffset from './ZoneOffset';

export default class BasicTimeManager implements ITimeManager {
	public async getEpochMillis() {
		return Date.now();
	}

	public async getZoneOffset() {
		return ZoneOffset.fromPosix(new Date().getTimezoneOffset());
	}

	public async canGetZoneId() {
		return false;
	}

	public async getZoneId(): Promise<string> {
		throw new Error('Device is unable to return timezone');
	}

	public async canGetNtpServer() {
		return false;
	}

	public async getNtpServer(): Promise<string | null> {
		throw new Error('Device is unable to return NTP server');
	}

	public async canSetManual() {
		return false;
	}

	public async setManual() {
		throw new Error('Device is unable to set time manually');
	}

	public async canSetAuto() {
		return false;
	}

	public async setAuto() {
		throw new Error('Device is unable to set time automatically');
	}

	public async isAutoEnabled(): Promise<boolean> {
		return false;
	}
}
