import IScreenRotationPropsProvider, { IScreenRotationProps } from './IScreenRotationPropsProvider';
import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';

export default class ScreenRotationViewportPropsProvider implements IScreenRotationPropsProvider {
	/**
	 * @param rotateClockwise On most platforms, counter-clockwise should be the correct option
	 */
	constructor(private rotateClockwise: boolean) {}

	public getProps(orientation: Orientation): IScreenRotationProps {
		if (this.rotateClockwise) {
			return this.getClockwiseProps(orientation);
		} else {
			return this.getCounterClockwiseProps(orientation);
		}
	}

	private getClockwiseProps(orientation: Orientation) {
		switch (orientation) {
			case Orientation.PORTRAIT:
				return this.getCounterClockwiseProps(Orientation.PORTRAIT_FLIPPED);
			case Orientation.PORTRAIT_FLIPPED:
				return this.getCounterClockwiseProps(Orientation.PORTRAIT);
			default:
				return this.getCounterClockwiseProps(orientation);
		}
	}

	private getCounterClockwiseProps(orientation: Orientation) {
		const angles: {
			[orientation: string]: {
				angle: number;
				translateX: string;
				translateY: string;
				width: string;
				height: string;
			};
		} = {
			[Orientation.LANDSCAPE]: {
				angle: 0,
				translateX: '0%',
				translateY: '0%',
				width: '100vw',
				height: '100vh',
			},
			[Orientation.PORTRAIT_FLIPPED]: {
				angle: 90,
				translateX: '0%',
				translateY: '-100vw',
				width: '100vh',
				height: '100vw',
			},
			[Orientation.LANDSCAPE_FLIPPED]: {
				angle: 180,
				translateX: '-100vw',
				translateY: '-100vh',
				width: '100vw',
				height: '100vh',
			},
			[Orientation.PORTRAIT]: {
				angle: 270,
				translateX: '-100vh',
				translateY: '0%',
				width: '100vh',
				height: '100vw',
			},
		};

		return angles[orientation];
	}
}
