import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
import IScreenRotationPropsProvider, { IScreenRotationProps } from './IScreenRotationPropsProvider';

export default class ScreenRotationPixelPropsProvider implements IScreenRotationPropsProvider {
	/**
	 * @param rotateClockwise On most platforms, counter-clockwise should be the correct option
	 * @param resContains Usually a simple window, but with limited access to inner resolutions only
	 */
	constructor(
		private rotateClockwise: boolean,
		private resContainer: Pick<Window, 'innerWidth' | 'innerHeight'>,
	) {}

	public getProps(orientation: Orientation): IScreenRotationProps {
		if (this.rotateClockwise) {
			return this.getClockwiseProps(orientation);
		} else {
			return this.getCounterClockwiseProps(orientation);
		}
	}

	private getClockwiseProps(orientation: Orientation) {
		switch (orientation) {
			case Orientation.PORTRAIT:
				return this.getCounterClockwiseProps(Orientation.PORTRAIT_FLIPPED);
			case Orientation.PORTRAIT_FLIPPED:
				return this.getCounterClockwiseProps(Orientation.PORTRAIT);
			default:
				return this.getCounterClockwiseProps(orientation);
		}
	}

	private getCounterClockwiseProps(orientation: Orientation) {
		const windowWidth = this.resContainer.innerWidth;
		const windowHeight = this.resContainer.innerHeight;
		const angles: {
			[orientation: string]: {
				angle: number;
				translateX: string;
				translateY: string;
				width: string;
				height: string;
			};
		} = {
			[Orientation.LANDSCAPE]: {
				angle: 0,
				translateX: '0%',
				translateY: '0%',
				width: `${windowWidth}px`,
				height: `${windowHeight}px`,
			},
			[Orientation.PORTRAIT_FLIPPED]: {
				angle: 90,
				translateX: '0%',
				translateY: `-${windowWidth}px`,
				width: `${windowHeight}px`,
				height: `${windowWidth}px`,
			},
			[Orientation.LANDSCAPE_FLIPPED]: {
				angle: 180,
				translateX: `-${windowWidth}px`,
				translateY: `-${windowHeight}px`,
				width: `${windowWidth}px`,
				height: `${windowHeight}px`,
			},
			[Orientation.PORTRAIT]: {
				angle: 270,
				translateX: `-${windowHeight}px`,
				translateY: '0%',
				width: `${windowHeight}px`,
				height: `${windowWidth}px`,
			},
		};

		return angles[orientation];
	}
}
