import Property from '../../Property/Property';
import { IPropertyStorage } from '../../Property/propertyStorage';
import IPowerActionTimerStorage from './IPowerActionTimerStorage';
import MigratingPowerActionTimerPropertyStorage from './MigratingPowerActionTimerPropertyStorage';
import PowerActionTimerPropertyStorage, { PowerActionRulesProperty } from './PowerActionTimerPropertyStorage';

export function createPowerActionTimerPropertyStorage(
	propertyStorage: IPropertyStorage,
	property: PowerActionRulesProperty,
): IPowerActionTimerStorage {
	const oldStorage = () => new PowerActionTimerPropertyStorage(propertyStorage, Property.POWER_ACTIONS_SCHEDULE_SETTINGS);
	const newStorage = new PowerActionTimerPropertyStorage(propertyStorage, property);
	return new MigratingPowerActionTimerPropertyStorage(oldStorage, newStorage);
}
