import IPowerActionTimer, { PowerActionRule, PowerActionRules } from './IPowerActionTimer';

/**
 * A Power Action Timer that doesn't support persisting rules
 * and scheduling power actions (will throw error).
 */
export default class NotImplementedPowerActionTimer implements IPowerActionTimer {
	/**
	 * @throws Unsupported operation
	 */
	public async set(_uid: string, _rule: PowerActionRule): Promise<void> {
		throw new Error('Unsupported operation');
	}

	/**
	 * @throws Unsupported operation
	 */
	public async unset(..._uid: string[]): Promise<void> {
		throw new Error('Unsupported operation');
	}

	/**
	 * @throws Unsupported operation
	 */
	public async reset(): Promise<void> {
		throw new Error('Unsupported operation');
	}

	/**
	 * @returns An empty set of rules
	 */
	public async rules(): Promise<PowerActionRules> {
		return {};
	}

	/**
	 * Does nothing.
	 */
	public async notifyStart(): Promise<void> {
		// No-op.
	}

	/**
	 * Does nothing.
	 */
	public async notifyEnd(): Promise<void> {
		// No-op.
	}
}
