import { NetworkInterfaces } from '@signageos/common-types/dist/Device/Network/NetworkInterface';

export interface INetworkOptions {
	localAddress: string;
	gateway: string;
	netmask: string;
	dns: string[];
}

export default interface INetwork {
	listInterfaces(): Promise<NetworkInterfaces[]>;
	setManual(ifaceName: string, options: INetworkOptions): Promise<void>;
	setDHCP(ifaceName: string): Promise<void>;
	disableInterface(ifaceName: string): Promise<void>;
}
