// Number values are important because it's part of public API
export enum KeyCode {
	UNKNOWN = -1,
	NUM_0 = 0,
	NUM_1 = 1,
	NUM_2 = 2,
	NUM_3 = 3,
	NUM_4 = 4,
	NUM_5 = 5,
	NUM_6 = 6,
	NUM_7 = 7,
	NUM_8 = 8,
	NUM_9 = 9,
	ARROW_LEFT = 10,
	ARROW_UP = 11,
	ARROW_RIGHT = 12,
	ARROW_DOWN = 13,
	OK = 14,
	YELLOW = 15,
	BLUE = 16,
	RED = 17,
	GREEN = 18,
	VOLUME_DOWN = 19,
	VOLUME_UP = 20,
	POWER = 21,
	POWER_OFF = 22,
	HOME = 23,
	EXIT = 24,
	RETURN = 25,
	BACKSPACE = 26,
	LOCK = 27,
	BACKWARD = 28,
	FORWARD = 29,
	PLAY = 30,
	PAUSE = 31,
	STOP = 32,
	PLAY_PAUSE = 33,
	VOLUME_MUTE = 34,
	CHANNEL_UP = 35,
	CHANNEL_DOWN = 36,
	// https://developer.samsung.com/smarttv/develop/guides/user-interaction/remote-control.html
	MEDIA_TRACK_NEXT = 37,
	MEDIA_TRACK_PREVIOUS = 38,
	// Sony RMF-TX520U, Sony RMT-TB400U
	// PERIOD = 39, // Reserved.
	/** Record media key. */
	MEDIA_RECORD = 40,
	/** Info key. Common on TV remotes to show additional information related to what is currently being viewed. */
	INFO = 41,
	/** Guide key. On TV remotes, shows a programming guide. */
	GUIDE = 42,
	/** Toggle captions key. Switches the mode for closed-captioning text, for example during television shows. */
	CAPTIONS = 43,
	/** Audio Track key. Switches the audio tracks. */
	MEDIA_AUDIO_TRACK = 44,
}

export const keyboardKeyMap: { [key: string]: KeyCode } = {
	'0': KeyCode.NUM_0,
	'1': KeyCode.NUM_1,
	'2': KeyCode.NUM_2,
	'3': KeyCode.NUM_3,
	'4': KeyCode.NUM_4,
	'5': KeyCode.NUM_5,
	'6': KeyCode.NUM_6,
	'7': KeyCode.NUM_7,
	'8': KeyCode.NUM_8,
	'9': KeyCode.NUM_9,
	Enter: KeyCode.OK,
	Backspace: KeyCode.RETURN,
	Escape: KeyCode.EXIT,
	ArrowUp: KeyCode.ARROW_UP,
	ArrowDown: KeyCode.ARROW_DOWN,
	ArrowLeft: KeyCode.ARROW_LEFT,
	ArrowRight: KeyCode.ARROW_RIGHT,
	Home: KeyCode.HOME,
	Q: KeyCode.YELLOW,
	W: KeyCode.YELLOW,
	E: KeyCode.RED,
	R: KeyCode.GREEN,
	F9: KeyCode.POWER_OFF,
	F10: KeyCode.POWER,
};
