import { IFilePath, IFile, IHeaders, IStorageUnit } from './fileSystem';
import HashAlgorithm from './HashAlgorithm';

export interface ICopyFileOptions {
	overwrite?: boolean;
}

export interface IMoveFileOptions {
	overwrite?: boolean;
}

export interface IArchiveInfo {
	uncompressedSize: number;
}

export default interface IFileSystem {
	listStorageUnits(): Promise<IStorageUnit[]>;
	onStorageUnitsChanged(listener: () => void): void;

	listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
	getFile(filePath: IFilePath): Promise<IFile | null>;

	readFile(filePath: IFilePath): Promise<string>;
	writeFile(filePath: IFilePath, contents: string): Promise<void>;
	appendFile(filePath: IFilePath, contents: string): Promise<void>;
	exists(filePath: IFilePath): Promise<boolean>;
	downloadFile(filePath: IFilePath, sourceUri: string, headers?: IHeaders): Promise<void>;
	uploadFile(filePath: IFilePath, uri: string, formKey: string, headers?: IHeaders): Promise<string | undefined>;
	deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
	copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions): Promise<void>;
	moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions): Promise<void>;
	link(sourceFilePath: IFilePath, destinationFilePath: IFilePath): Promise<void>;
	getFileChecksum(filePath: IFilePath, hashType: HashAlgorithm): Promise<string>;
	extractFile(archiveFilePath: IFilePath, destinationDirectoryPath: IFilePath, method: string): Promise<void>;
	createArchive(destinationFilePath: IFilePath, archiveEntries: IFilePath[]): Promise<void>;

	createDirectory(directoryPath: IFilePath): Promise<void>;
	isDirectory(filePath: IFilePath): Promise<boolean>;
	getArchiveInfo(archiveFilePath: IFilePath): Promise<IArchiveInfo>;
	/**
	 * Method used to run power action - wipeout file system
	 */
	wipeout(): Promise<void>;
}
