import ISerial, { IOptions, ISerialPort } from './ISerial';
import { NotSupportedMethodError } from '../Error/basicErrors';

export default class NotImplementedSerial implements ISerial {
	public async openPort(_options: IOptions): Promise<ISerialPort> {
		throw new NotSupportedMethodError('openPort');
	}

	public closeAll(): Promise<void> {
		throw new NotSupportedMethodError('closeAll');
	}
}
