export type TDisplay = 'SAMSUNG' | 'SYNCMASTER';
export enum DisplayType {
	SAMSUNG = 'SAMSUNG',
	SYNCMASTER = 'SYNCMASTER',
}

export default interface IDisplayManager {
	/**
	 * Returns ID of connected display from Navigator USB API
	 */
	getConnectedDisplay(): Promise<TDisplay | undefined>;
	/**
	 * Returns true if device has been successfully connected to display
	 * over serial connection.
	 */
	isSerialConnectionAvailable(): Promise<boolean>;
	/**
	 * Sends command to connected display.
	 * @param command Command number (ex. MDC)
	 * @param values Command additional values
	 */
	sendCommand(command: number, values?: [number]): Promise<void>;
}
