import IFrontDriver from '../Front/IFrontDriver';
import ICacheDriver from '../ICacheDriver';
import IManagementDriver from '../Management/IManagementDriver';

export type ManagementCacheDriver = (IManagementDriver & ICacheDriver) | NormalizedManagementCacheDriver;

export type NormalizedManagementCacheDriver = {
	managementDriver: IManagementDriver;

	cacheDriver: ICacheDriver;
};

export type FrontCacheDriver = (IFrontDriver & ICacheDriver) | NormalizedFrontCacheDriver;

export type NormalizedFrontCacheDriver = {
	frontDriver: IFrontDriver;
	cacheDriver: ICacheDriver;
};

export const normalizeManagementCacheDriver = (managementCacheDriver: ManagementCacheDriver): NormalizedManagementCacheDriver => {
	if ('managementDriver' in managementCacheDriver) {
		return managementCacheDriver;
	}

	return {
		managementDriver: managementCacheDriver,
		cacheDriver: managementCacheDriver,
	};
};

export const normalizeFrontCacheDriver = (combinedDriver: FrontCacheDriver): NormalizedFrontCacheDriver => {
	if ('frontDriver' in combinedDriver) {
		return combinedDriver;
	}

	return {
		frontDriver: combinedDriver,
		cacheDriver: combinedDriver,
	};
};
