import ICache from '../../Cache/ICache';
import ProprietaryCache from '../../Cache/ProprietaryCache';
import ICacheDriver from '../ICacheDriver';
import ICacheStorageInfo from '../ICacheStorageInfo';

export default class DefaultCacheDriver implements ICacheDriver {
	private cache: ICache;

	constructor(storage: Storage) {
		const DEFAULT_TOTAL_SIZE_BYTES = 5 * 1024 * 1024; // Default quota of localStorage in browsers
		this.cache = new ProprietaryCache(storage, DEFAULT_TOTAL_SIZE_BYTES);
	}

	public cacheGetUids() {
		return this.cache.fetchAllUids();
	}

	public cacheGetAll() {
		return this.cache.fetchAll();
	}

	public cacheGet(uid: string) {
		return this.cache.fetchOne(uid);
	}

	public cacheDelete(uid: string) {
		return this.cache.deleteOne(uid);
	}

	public cacheSave(uid: string, content: string) {
		return this.cache.saveOne(uid, content);
	}

	public cacheGetStorageInfo(): Promise<ICacheStorageInfo> {
		return this.cache.getStorageInfo();
	}
}
