import Cookies from 'js-cookie';
import url from 'url';
import IBasicDriver from '../IBasicDriver';

export class DefaultBasicDriver implements IBasicDriver {
	public static async support(_window: Window) {
		return true;
	}

	constructor(
		private window: Window,
		private deviceUid: string,
	) {}

	public async getConfigurationBaseUrl() {
		const currentLocation = url.parse(this.window.location.href, true);
		return currentLocation.query.platformBaseUrl ? (currentLocation.query.platformBaseUrl as string) : null;
	}

	public getApplicationType() {
		return 'default';
	}

	public start() {
		// do nothing
	}

	public stop() {
		// do nothing
	}

	public async getDeviceUid() {
		return this.deviceUid;
	}

	public async isConnected() {
		return this.window.navigator.onLine;
	}

	public async getSessionId(sessionIdKey: string) {
		const duid = this.deviceUid;
		const sessionRaw = Cookies.get(sessionIdKey);
		try {
			const sessionIdMap = sessionRaw ? JSON.parse(sessionRaw) : {};
			return sessionIdMap[duid];
		} catch (e) {
			return undefined;
		}
	}

	public async setSessionId(sessionIdKey: string, sessionId: string) {
		const duid = this.deviceUid;
		const sessionRaw = Cookies.get(sessionIdKey);
		let sessionIdMap;
		try {
			sessionIdMap = sessionRaw ? JSON.parse(sessionRaw) : {};
		} catch (e) {
			sessionIdMap = {};
		}
		sessionIdMap[duid] = sessionId;
		Cookies.set(sessionIdKey, sessionIdMap, {
			expires: 10 * 365,
		});
	}
}
