import * as t from './../../Test/TestFramework';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import should from '../../Test/should';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import { TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';

export default async (nativeDriver: IManagementDriver) => {
	return t.describe(TestCase.REMOTE_CONTROL, function* () {
		yield t.it('Should enable/disable remote control', async () => {
			if (!(await nativeDriver.managementSupports(ManagementCapability.SET_REMOTE_CONTROL_ENABLED))) {
				t.skip(`The device does not provide "${ManagementCapability.SET_REMOTE_CONTROL_ENABLED}" capability`);
			}

			const wasOn = await nativeDriver.remoteControlIsEnabled();
			should(wasOn).be.oneOf([true, false]);

			await nativeDriver.remoteControlSetEnabled(true);
			should(await nativeDriver.remoteControlIsEnabled()).be.true();

			await nativeDriver.remoteControlSetEnabled(false);
			should(await nativeDriver.remoteControlIsEnabled()).be.false();

			await nativeDriver.remoteControlSetEnabled(wasOn);
		});
	});
};
