import { put, takeEvery } from 'redux-saga/effects';
import { UpdateDeviceTelemetryRecord } from '@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions';
import { DateTimeSettings } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { TimeSettingsChanged } from '@signageos/common-types/dist/Device/SystemLogs/systemLogs';
import { createSystemLogAction } from '../../SystemLogs/systemLogActionFactory';

export function* systemLogsSaga() {
	yield takeEvery(
		UpdateDeviceTelemetryRecord,
		function* (action: UpdateDeviceTelemetryRecord<DeviceSettingsType.DATETIME, DateTimeSettings>): IterableIterator<any> {
			if (action.name === DeviceSettingsType.DATETIME) {
				yield put(
					createSystemLogAction({
						type: TimeSettingsChanged,
					} satisfies TimeSettingsChanged),
				);
			}
		},
	);
}
