import {
	SetExtendedManagementUrlFailed,
	SetExtendedManagementUrlSucceeded,
	SetExtendedManagementUrl,
} from '@signageos/actions/dist/Device/ExtendedManagement/deviceExtendedManagementActions';
import { apply, put, takeEvery } from 'redux-saga/effects';
import { IResponsibilities } from '../../Feature/Responsibilities';
import Responsibility from '../../Feature/Responsibility';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import { bindWhenPlatform } from '../../Socket/socketActionCreator';

export function* setDeviceExtendedManagementCallback(getNativeDriver: () => IManagementDriver, action: SetExtendedManagementUrl) {
	try {
		const nativeDriver = getNativeDriver();

		yield apply(nativeDriver, nativeDriver.setExtendedManagementUrl, [action.url]);
		yield put({
			type: SetExtendedManagementUrlSucceeded,
			uid: action.uid,
		} as SetExtendedManagementUrlSucceeded);
	} catch (error) {
		console.error('deviceVolumeSaga', error);
		yield put({
			type: SetExtendedManagementUrlFailed,
			uid: action.uid,
		} as SetExtendedManagementUrlFailed);
	}
}

export function* deviceExtendedManagementSaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.EXTENDED_MANAGEMENT)) {
		return;
	}

	yield bindWhenPlatform(SetExtendedManagementUrl);

	const supports: boolean = yield getNativeDriver().managementSupports(ManagementCapability.EXTENDED_MANAGEMENT);

	if (supports) {
		yield takeEvery(SetExtendedManagementUrl, setDeviceExtendedManagementCallback, getNativeDriver);
	}
}
