import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import { IPropertyStorage } from '../../../Property/propertyStorage';
import { IProprietaryTimerStorage } from '../../../Timer/ITimerStorage';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import { all } from 'redux-saga/effects';
import { telemetryDeviceVolumeSaga } from '../../Device/Audio/deviceVolumeTelemetrySagas';
import { telemetryBrightnessSettingsSaga } from '../../Device/Brightness/brightnessTelemetrySagas';
import { telemetryResolutionSaga } from '../../Device/Screen/deviceResolutionTelemetrySagas';
import { telemetryOrientationSaga } from '../../Device/Screen/deviceOrientationTelemetrySagas';
import { telemetryDeviceRemoteControlSaga } from '../../Device/RemoteControl/deviceRemoteControlTelemetrySagas';
import { telemetryDeviceApplicationSaga } from '../../Device/Application/deviceApplicationTelemetrySagas';
import { telemetryDeviceFirmwareSaga } from '../../Device/Firmware/deviceFirmwareTelemetrySagas';
import { telemetryDeviceDebugSaga } from '../../Device/Debug/deviceDebugTelemetrySagas';
import { telemetryDeviceDateTimeSaga } from '../../Device/DateTime/deviceDateTimeTelemetrySagas';
import { telemetryDevicePowerActionsSaga } from '../../Device/Power/devicePowerActionTelemetrySagas';
import { telemetryDeviceProprietaryTimerSaga, telemetryDeviceTimerSaga } from '../../Device/Timer/deviceTimerTelemetrySagas';
import { telemetryTemperatureSettingsSaga } from '../../Device/Temperature/temperatureTelemetrySagas';
import { telemetryDeviceBundledAppletSaga } from '../../Device/BundledApplet/deviceBundledAppletTelemetrySagas';
import { telemetryDeviceProxySaga } from '../Proxy/deviceProxyTelemetrySaga';
import { telemetryDeviceWifiStrenghtSaga } from '../Network/deviceWifiStrengthTelemetrySaga';
import { telemetryDeviceAutoRecoverySaga } from '../AutoRecovery/autoRecoveryTelemetrySaga';
import { telemetryDevicePeerRecoverySaga } from '../PeerRecovery/peerRecoveryTelemetrySaga';
import { telemetryManagementCapabilitiesSaga } from '../Capabilities/deviceCapabilitiesTelemetrySagas';
import IPowerActionTimer from '../../../NativeDevice/Power/IPowerActionTimer';
import { telemetryExtendedManagementSettingsSaga } from '../../Extended/extendedManagementTelemetrySagas';
import { telemetryNetworkInfo } from '../Network/deviceNetworkTelemetrySaga';
import { telemetryDisplayPowerOnSaga } from '../Display/telemetryDisplayPowerOnSaga';
import { telemetryAppModulesSaga } from '../AppModules/telemetryAppModulesSaga';
import { telemetryFeatureFlagsSaga } from '../../FeatureFlags/deviceFeatureFlegsTelemetrySaga';
import { telemetryCryptographicSaga } from '../Secrets/deviceCryphotraphicTelemetrySaga';

export const deviceTelemetrySaga = (
	responsibilities: IResponsibilities,
	getNativeDriver: () => IManagementDriver,
	propertyStorage: IPropertyStorage,
	proprietaryTimerStorage: IProprietaryTimerStorage,
	applicationVersion: string,
	powerActionTimer: IPowerActionTimer,
) =>
	function* () {
		const powerActionRules = async () => await powerActionTimer.rules();
		const telemetrySagas = [
			telemetryDeviceVolumeSaga,
			telemetryBrightnessSettingsSaga,
			telemetryResolutionSaga,
			telemetryOrientationSaga,
			telemetryDeviceRemoteControlSaga,
			telemetryDeviceApplicationSaga,
			telemetryDeviceFirmwareSaga,
			telemetryDeviceDebugSaga,
			telemetryDeviceDateTimeSaga,
			telemetryDevicePowerActionsSaga,
			telemetryDeviceTimerSaga,
			telemetryDeviceProprietaryTimerSaga,
			telemetryTemperatureSettingsSaga,
			telemetryDeviceBundledAppletSaga,
			telemetryNetworkInfo,
			telemetryDeviceProxySaga,
			telemetryDeviceWifiStrenghtSaga,
			telemetryDeviceAutoRecoverySaga,
			telemetryDevicePeerRecoverySaga,
			telemetryManagementCapabilitiesSaga,
			telemetryExtendedManagementSettingsSaga,
			telemetryDisplayPowerOnSaga,
			telemetryAppModulesSaga,
			telemetryFeatureFlagsSaga,
			telemetryCryptographicSaga,
		];
		const telemetrySagaIterators = telemetrySagas.map((saga) => {
			return saga(responsibilities, getNativeDriver, propertyStorage, proprietaryTimerStorage, powerActionRules, applicationVersion);
		});
		yield all(telemetrySagaIterators);
	};
