import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { getResolutionSettings } from './deviceResolutionTelemetrySagas';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Management:Policy:Resolution');

export const deviceResolutionPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.RESOLUTION,
	Responsibility.SCREEN,
	ManagementCapability.SCREEN_RESIZE,
	checkAndSetResolutionSettings,
);

export async function* checkAndSetResolutionSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.RESOLUTION>) {
	const resolutionSettings = properties.policy.value;
	const { managementDriver } = properties;
	const currentResolutionSettings = await getResolutionSettings(properties);
	debug('comparing resolution settings %s === %s', JSON.stringify(resolutionSettings), JSON.stringify(currentResolutionSettings));
	if (resolutionSettings.width !== currentResolutionSettings.width || resolutionSettings.height !== currentResolutionSettings.height) {
		const callback = await managementDriver.setResolution(resolutionSettings);
		if (typeof callback === 'function') {
			callback();
		}
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
