import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import _ from 'lodash';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { getOrientationSettings } from './deviceOrientationTelemetrySagas';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const deviceOrientationPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.ORIENTATION,
	Responsibility.SCREEN,
	ManagementCapability.SCREEN_RESIZE,
	checkAndSetOrientationSettings,
);

export async function* checkAndSetOrientationSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.ORIENTATION>) {
	const orientationSettings = properties.policy.value;
	const { managementDriver, getStaticBaseUrl } = properties;
	const currentResizeSettings = await getOrientationSettings(properties);

	if (!_.isEqual(orientationSettings, currentResizeSettings)) {
		const callback = await managementDriver.setOrientation(
			getStaticBaseUrl(),
			orientationSettings.orientation,
			orientationSettings.videoOrientation,
		);
		if (typeof callback === 'function') {
			callback();
		}
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
