import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDeviceRemoteControlSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.REMOTE_CONTROL,
	Responsibility.KIOSK,
	[ManagementCapability.SET_REMOTE_CONTROL_ENABLED],
	getRemoteControlSettings,
);

export async function getRemoteControlSettings({ managementDriver }: IGetTelemetryProperties) {
	return { enabled: await managementDriver.remoteControlIsEnabled() };
}
