import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { call, put, apply, takeEvery } from 'redux-saga/effects';
import {
	SetDeviceRemoteControlSettings,
	SetDeviceRemoteControlSettingsSucceeded,
	SetDeviceRemoteControlSettingsFailed,
} from '@signageos/actions/dist/Device/RemoteControl/deviceRemoteControlActions';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import { DeviceRemoteControlSet } from '../../../Device/RemoteControl/deviceRemoteControlActions';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import processCallback, { ICallback } from '../../../Util/processCallback';

export function* setDeviceRemoteControlSettingsCallback(getNativeDriver: () => IManagementDriver, action: SetDeviceRemoteControlSettings) {
	const nativeDriver = getNativeDriver();
	try {
		const finalizeCallback: ICallback = yield apply(nativeDriver, nativeDriver.remoteControlSetEnabled, [action.enabled]);
		yield put({
			type: SetDeviceRemoteControlSettingsSucceeded,
			uid: action.uid,
		} as SetDeviceRemoteControlSettingsSucceeded);
		yield put({
			type: DeviceRemoteControlSet,
			enabled: action.enabled,
		} as DeviceRemoteControlSet);
		yield call(processCallback, finalizeCallback);
	} catch (error) {
		yield put({
			type: SetDeviceRemoteControlSettingsFailed,
			uid: action.uid,
		} as SetDeviceRemoteControlSettingsFailed);
	}
}

export function* syncRemoteControlSettingsSaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.KIOSK)) {
		return;
	}

	yield bindWhenPlatform(SetDeviceRemoteControlSettings);

	const supportsRCEnabled: boolean = yield getNativeDriver().managementSupports(ManagementCapability.SET_REMOTE_CONTROL_ENABLED);
	if (supportsRCEnabled) {
		yield takeEvery(SetDeviceRemoteControlSettings, setDeviceRemoteControlSettingsCallback, getNativeDriver);
	}
}
