import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import processCallback from '../../../Util/processCallback';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { getRemoteControlSettings } from './deviceRemoteControlTelemetrySagas';

export const deviceRemoteControlPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.REMOTE_CONTROL,
	Responsibility.KIOSK,
	ManagementCapability.SET_REMOTE_CONTROL_ENABLED,
	checkAndSetRemoteControlSettings,
);

export async function* checkAndSetRemoteControlSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.REMOTE_CONTROL>) {
	const remoteControlSettings = properties.policy.value;
	const currentRemoteControlSettings = await getRemoteControlSettings(properties);
	if (currentRemoteControlSettings.enabled !== remoteControlSettings.enabled) {
		const finalizeCallback = await properties.managementDriver.remoteControlSetEnabled(remoteControlSettings.enabled);
		processCallback(finalizeCallback);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
