import ICacheDriver from '../../../NativeDevice/ICacheDriver';
import CronPowerActionScheduler from '../../../NativeDevice/Power/CronPowerActionScheduler';
import DefaultPowerActionTimer from '../../../NativeDevice/Power/DefaultPowerActionTimer';
import IPowerActionTimer from '../../../NativeDevice/Power/IPowerActionTimer';
import { createPowerActionTimerPropertyStorage } from '../../../NativeDevice/Power/powerActionTimerStorages';
import Property from '../../../Property/Property';
import createPropertyStorage from '../../../Property/propertyStorage';
import ManagementPowerActionExecutor from './ManagementPowerActionExecutor';
import { PowerFacade } from './powerFacade';

export function createManagementPowerActionTimer(getNativeDriver: () => ICacheDriver, powerFacade: PowerFacade): IPowerActionTimer {
	const propertyStorage = createPropertyStorage(getNativeDriver);
	const storage = createPowerActionTimerPropertyStorage(propertyStorage, Property.POWER_ACTIONS_SCHEDULE_SETTINGS_MANAGEMENT);
	const scheduler = new CronPowerActionScheduler();
	const executor = new ManagementPowerActionExecutor(powerFacade);
	return new DefaultPowerActionTimer(storage, scheduler, executor);
}
