import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { CancelScheduledPowerAction, SchedulePowerAction } from '@signageos/actions/dist/Device/Power/devicePowerActions';
import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import IPowerActionTimer from '../../../NativeDevice/Power/IPowerActionTimer';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { deviceSchedulePowerActionCommon } from '../../../Device/Power/deviceSchedulePowerActionSagas';

export function* deviceSchedulePowerAction(
	getNativeDriver: () => IManagementDriver,
	responsibilities: IResponsibilities,
	powerActionTimer: IPowerActionTimer,
) {
	if (!responsibilities.has(Responsibility.SCHEDULED_POWER)) {
		return;
	}

	yield bindWhenPlatform([SchedulePowerAction, CancelScheduledPowerAction]);

	const supportsSchedulePowerAction: boolean = yield getNativeDriver().managementSupports(ManagementCapability.SCHEDULE_POWER_ACTION);
	if (!supportsSchedulePowerAction) {
		return;
	}

	yield deviceSchedulePowerActionCommon(powerActionTimer, (powerType: PowerActionType) => {
		return (
			powerType === PowerActionType.SYSTEM_REBOOT ||
			powerType === PowerActionType.APP_RESTART ||
			powerType === PowerActionType.DISPLAY_POWER_ON ||
			powerType === PowerActionType.DISPLAY_POWER_OFF
		);
	});
}
