import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import { PowerActionsScheduleSettings } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { getPowerActionsScheduleSettings } from './devicePowerActionTelemetrySagas';
import Weekday from '@signageos/actions/dist/Misc/Weekday';
import CommonWeekday from '@signageos/common-types/dist/Device/Time/Weekday';
import { put } from 'redux-saga/effects';
import { CancelScheduledPowerAction, SchedulePowerAction } from '@signageos/actions/dist/Device/Power/devicePowerActions';
import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const devicePowerActionPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.POWER_ACTIONS_SCHEDULE,
	Responsibility.SCHEDULED_POWER,
	ManagementCapability.SCHEDULE_POWER_ACTION,
	checkAndSetPowerActionsScheduleSettings,
);

export async function* checkAndSetPowerActionsScheduleSettings(
	properties: IPolicyCheckAndSetProperties<DeviceSettingsType.POWER_ACTIONS_SCHEDULE>,
) {
	let changed = CheckAndSetResult.NOT_CHANGED;
	const powerActionsScheduleSettings = properties.policy.value.map((powerAction: PowerActionsScheduleSettings) => ({
		...powerAction,
		uid: `policy-${powerAction.uid}`,
	}));
	const currentPowerActionsScheduleSettings = await getPowerActionsScheduleSettings(properties);
	for (let powerAction of powerActionsScheduleSettings) {
		if (!isPowerActionInList(currentPowerActionsScheduleSettings, powerAction)) {
			changed = CheckAndSetResult.CHANGED;
			yield put({
				type: SchedulePowerAction,
				uid: powerAction.uid,
				powerType: PowerActionType[powerAction.powerType],
				weekdays: powerAction.weekdays.map((weekday: CommonWeekday) => Weekday[weekday]),
				time: powerAction.time,
			});
		}
	}
	for (let powerAction of currentPowerActionsScheduleSettings) {
		if (!isPowerActionInList(powerActionsScheduleSettings, powerAction)) {
			changed = CheckAndSetResult.CHANGED;
			yield put({
				type: CancelScheduledPowerAction,
				scheduledPowerActionUid: powerAction.uid,
			});
		}
	}
	return changed;
}

export function isPowerActionInList(list: PowerActionsScheduleSettings[], powerAction: PowerActionsScheduleSettings) {
	return list.some((powerActionInList: PowerActionsScheduleSettings) => powerActionInList.uid === powerAction.uid);
}
