import { all } from 'redux-saga/effects';
import { deviceBrightnessPolicySaga } from '../../Device/Brightness/brightnessPolicySagas';
import { deviceVolumePolicySaga } from '../../Device/Audio/deviceVolumePolicySagas';
import { deviceResolutionPolicySaga } from '../../Device/Screen/deviceResolutionPolicySagas';
import { deviceOrientationPolicySaga } from '../../Device/Screen/deviceOrientationPolicySagas';
import { deviceRemoteControlPolicySaga } from '../../Device/RemoteControl/deviceRemoteControlPolicySagas';
import { deviceApplicationPolicySaga } from '../../Device/Application/deviceApplicationPolicySagas';
import { deviceFirmwarePolicySaga } from '../../Device/Firmware/deviceFirmwarePolicySagas';
import { deviceDebugPolicySaga } from '../../Device/Debug/deviceDebugPolicySagas';
import { deviceDateTimePolicySaga } from '../../Device/DateTime/deviceDateTimePolicySagas';
import { devicePowerActionPolicySaga } from '../../Device/Power/devicePowerActionPolicySagas';
import { deviceProprietaryTimerPolicySaga, deviceTimerPolicySaga } from '../../Device/Timer/deviceTimerPolicySagas';
import { deviceExtendedManagementPolicySaga } from '../../Extended/extendedManagementPolicySagas';
import { devicePeerRecoveryPolicySaga } from '../PeerRecovery/peerRecoveryPolicySaga';
import { deviceAutoRecoveryPolicySaga } from '../AutoRecovery/autoRecoveryPolicySaga';

export function* devicePolicySaga(): IterableIterator<unknown> {
	yield all([
		deviceVolumePolicySaga(),
		deviceBrightnessPolicySaga(),
		deviceResolutionPolicySaga(),
		deviceOrientationPolicySaga(),
		deviceRemoteControlPolicySaga(),
		deviceApplicationPolicySaga(),
		deviceFirmwarePolicySaga(),
		deviceDebugPolicySaga(),
		deviceDateTimePolicySaga(),
		devicePowerActionPolicySaga(),
		deviceTimerPolicySaga(),
		deviceProprietaryTimerPolicySaga(),
		deviceExtendedManagementPolicySaga(),
		devicePeerRecoveryPolicySaga(),
		deviceAutoRecoveryPolicySaga(),
	]);
}
