import Property from '../../../Property/Property';
import { getPropertyName } from '../Telemetry/deviceTelemetrySagas';
import { IPropertyStorage } from '../../../Property/propertyStorage';
import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';

class FailsCount {
	private propertyKey: Property;
	constructor(
		private type: DeviceSettingsType,
		private propertyStorage: IPropertyStorage,
	) {
		this.propertyKey = getPropertyName(this.type, 'DEVICE_POLICY_FAILS_COUNT');
	}

	public async get() {
		return this.propertyStorage.getValueOrDefault<number>(this.propertyKey, 0);
	}

	public async reset() {
		return this.propertyStorage.setValue<number>(this.propertyKey, 0);
	}

	public async add() {
		const failsCount = await this.propertyStorage.getValueOrDefault<number>(this.propertyKey, 0);
		await this.propertyStorage.setValue<number>(this.propertyKey, failsCount + 1);
		return failsCount;
	}
}

export default FailsCount;
