import { bindAndTakeEveryOnlyWhenPlatform } from '../../../Socket/socketActionCreator';
import { put, call } from 'redux-saga/effects';
import {
	SetDevicePeerRecovery,
	SetDevicePeerRecoverySucceeded,
	SetDevicePeerRecoveryFailed,
} from '@signageos/actions/dist/Device/PeerRecovery/devicePeerRecoveryActions';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';
import { IPeerRecoveryConfiguration } from '../../../NativeDevice/IPeerRecovery';

export function* setDevicePeerRecovery(getNativeDriver: () => IManagementDriver, action: SetDevicePeerRecovery) {
	const nativeDriver = getNativeDriver();
	try {
		const configuration: IPeerRecoveryConfiguration = action.enabled
			? { enabled: true, urlLauncherAddress: action.urlLauncherAddress }
			: { enabled: false, autoEnableTimeoutMs: action.autoEnableTimeoutMs };
		yield call([nativeDriver, 'setPeerRecovery'], configuration);

		yield put<SetDevicePeerRecoverySucceeded>({
			type: SetDevicePeerRecoverySucceeded,
			uid: action.uid,
		});
	} catch (error) {
		yield put<SetDevicePeerRecoveryFailed>({
			type: SetDevicePeerRecoveryFailed,
			uid: action.uid,
		});
	}
}

export function* peerRecoverySaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.PEER_RECOVERY)) {
		return;
	}

	const nativeDriver = getNativeDriver();
	const supportPRenabled: boolean = yield call([nativeDriver, 'managementSupports'], ManagementCapability.PEER_RECOVERY);
	if (supportPRenabled) {
		yield bindAndTakeEveryOnlyWhenPlatform(SetDevicePeerRecovery, setDevicePeerRecovery, getNativeDriver);
	}
}
