import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { DeviceSettingsValue } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';

export const telemetryDisplayPowerOnSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.DISPLAY_POWER_ON,
	Responsibility.POWER,
	[ManagementCapability.DISPLAY_POWER],
	getSettings,
);

async function getSettings({
	managementDriver,
}: IGetTelemetryProperties): Promise<DeviceSettingsValue<DeviceSettingsType.DISPLAY_POWER_ON>> {
	return { powerOn: await managementDriver.displayIsPowerOn() };
}
