import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import Property from '../../../Property/Property';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDeviceDebugSaga = createDeviceTelemetrySaga(DeviceTelemetryType.DEBUG, Responsibility.DEBUG, [], getDebugSettings);

export async function getDebugSettings({ managementDriver, propertyStorage }: IGetTelemetryProperties) {
	const appletEnabled = await propertyStorage.getValueOrDefault(Property.DEBUG_WEINRE_ENABLED, false);
	return {
		appletEnabled: appletEnabled,
		nativeEnabled: await managementDriver.isDebugEnabled(),
	};
}
