import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { put, apply, call, takeEvery } from 'redux-saga/effects';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import {
	SetDeviceDebugSettings,
	SetDeviceDebugSettingsSucceeded,
	SetDeviceDebugSettingsFailed,
} from '@signageos/actions/dist/Device/Debug/deviceDebugActions';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import processCallback, { ICallback } from '../../../Util/processCallback';

export function* devicePerformDebugSettings(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.DEBUG)) {
		return;
	}

	yield bindWhenPlatform(SetDeviceDebugSettings);

	const supportsDebug: boolean = yield getNativeDriver().managementSupports(ManagementCapability.SET_DEBUG);
	if (supportsDebug) {
		yield takeEvery(SetDeviceDebugSettings, setDeviceDebugSettingsCallback, getNativeDriver);
	}
}

export function* setDeviceDebugSettingsCallback(getNativeDriver: () => IManagementDriver, { nativeEnabled, uid }: SetDeviceDebugSettings) {
	const nativeDriver = getNativeDriver();
	try {
		const finalizeCallback: ICallback = yield apply(nativeDriver, nativeDriver.setDebug, [nativeEnabled]);
		yield put({
			type: SetDeviceDebugSettingsSucceeded,
			uid,
		} as SetDeviceDebugSettingsSucceeded);
		yield call(processCallback, finalizeCallback);
	} catch (e) {
		yield put({
			type: SetDeviceDebugSettingsFailed,
			uid,
		} as SetDeviceDebugSettingsFailed);
	}
}
