import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import { getDebugSettings } from './deviceDebugTelemetrySagas';
import Property from '../../../Property/Property';
import _ from 'lodash';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const deviceDebugPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.DEBUG,
	Responsibility.DEBUG,
	ManagementCapability.SET_DEBUG,
	checkAndSetDebugSettings,
);

export async function* checkAndSetDebugSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.DEBUG>) {
	const debugSettings = properties.policy.value;
	const currentDebugSettings = await getDebugSettings(properties);

	if (!_.isEqual(debugSettings, currentDebugSettings)) {
		const weinreEnabled = debugSettings.appletEnabled;
		await properties.propertyStorage.setValue(Property.DEBUG_WEINRE_ENABLED, weinreEnabled);
		await properties.managementDriver.setDebug(debugSettings.nativeEnabled);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
