import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { apply, put, takeEvery } from 'redux-saga/effects';
import {
	SetDeviceBrightness,
	SetDeviceBrightnessSucceeded,
	SetDeviceBrightnessFailed,
} from '@signageos/actions/dist/Device/Brightness/deviceBrightnessActions';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import Property from '../../../Property/Property';
import { IPropertyStorage } from '../../../Property/propertyStorage';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';

export function* setDeviceBrightnessCallback(
	getNativeDriver: () => IManagementDriver,
	propertyStorage: IPropertyStorage,
	action: SetDeviceBrightness,
) {
	try {
		const nativeDriver = getNativeDriver();

		yield apply(nativeDriver, nativeDriver.screenSetBrightness, [
			action.timeFrom1,
			action.brightness1,
			action.timeFrom2,
			action.brightness2,
		]);

		yield apply(propertyStorage, propertyStorage.setValue, [
			Property.BRIGHTNESS_SETTINGS,
			{
				timeFrom1: action.timeFrom1,
				brightness1: action.brightness1,
				timeFrom2: action.timeFrom2,
				brightness2: action.brightness2,
			},
		]);

		yield put({
			type: SetDeviceBrightnessSucceeded,
			uid: action.uid,
		} as SetDeviceBrightnessSucceeded);
	} catch (error) {
		console.error('syncBrightnessSettingsSaga', error);
		yield put({
			type: SetDeviceBrightnessFailed,
			uid: action.uid,
		} as SetDeviceBrightnessFailed);
	}
}

export function* syncBrightnessSettingsSaga(
	getNativeDriver: () => IManagementDriver,
	responsibilities: IResponsibilities,
	propertyStorage: IPropertyStorage,
) {
	if (!responsibilities.has(Responsibility.BRIGHTNESS)) {
		return;
	}

	yield bindWhenPlatform(SetDeviceBrightness);

	const supportsBrightness: boolean = yield getNativeDriver().managementSupports(ManagementCapability.SET_BRIGHTNESS);
	if (supportsBrightness) {
		yield takeEvery(SetDeviceBrightness, setDeviceBrightnessCallback, getNativeDriver, propertyStorage);
	}
}
