import { put } from 'redux-saga/effects';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { NotifyBatteryStatus } from '@signageos/actions/dist/Device/Battery/batteryActions';
import Responsibility from '../../../Feature/Responsibility';
import { whenCapable } from '../../../Feature/capable';
import { withDependencies } from '../../../DI/dependencyInjection';
import IBatteryStatus from '../../../NativeDevice/Battery/IBatteryStatus';
import { registerTelemetry } from '../Telemetry/deviceTelemetryHelper';

export const deviceBatterySaga = () =>
	whenCapable(
		ManagementCapability.BATTERY_STATUS,
		withDependencies(
			['managementDriver', 'responsibilities', 'telemetryIntervals'],
			function* ({ managementDriver, responsibilities, telemetryIntervals }) {
				if (!responsibilities.has(Responsibility.BATTERY)) {
					return;
				}

				const periodMs = telemetryIntervals?.battery ?? 0;
				yield registerTelemetry('BATTERY', periodMs, function* () {
					try {
						const batteryStatus: IBatteryStatus = yield managementDriver.batteryGetStatus();
						yield put({
							type: NotifyBatteryStatus,
							batteryStatus,
						} as NotifyBatteryStatus);
					} catch (error) {
						console.error('deviceBatterySaga', error);
					}
				});
			},
		),
	);
