import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDeviceAutoRecoverySaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.AUTO_RECOVERY,
	Responsibility.AUTO_RECOVERY,
	[ManagementCapability.AUTO_RECOVERY],
	getAutoRecoverySetting,
);

export async function getAutoRecoverySetting({ managementDriver }: IGetTelemetryProperties) {
	return await managementDriver.getAutoRecovery();
}
