import { bindAndTakeEveryOnlyWhenPlatform } from '../../../Socket/socketActionCreator';
import { put, call } from 'redux-saga/effects';
import {
	SetDeviceAutoRecovery,
	SetDeviceAutoRecoverySucceeded,
	SetDeviceAutoRecoveryFailed,
} from '@signageos/actions/dist/Device/AutoRecovery/deviceAutoRecoveryActions';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';
import { IAutoRecoveryConfiguration } from '../../../NativeDevice/IAutoRecovery';

export function* setDeviceAutoRecovery(getNativeDriver: () => IManagementDriver, action: SetDeviceAutoRecovery) {
	const nativeDriver = getNativeDriver();
	try {
		const configuration: IAutoRecoveryConfiguration = action.enabled
			? { enabled: true, healthcheckIntervalMs: action.healthcheckIntervalMs }
			: { enabled: false, autoEnableTimeoutMs: action.autoEnableTimeoutMs };

		yield call([nativeDriver, 'setAutoRecovery'], configuration);

		yield put<SetDeviceAutoRecoverySucceeded>({
			type: SetDeviceAutoRecoverySucceeded,
			uid: action.uid,
		});
	} catch (error) {
		yield put<SetDeviceAutoRecoveryFailed>({
			type: SetDeviceAutoRecoveryFailed,
			uid: action.uid,
		});
	}
}

export function* autoRecoverySaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.AUTO_RECOVERY)) {
		return;
	}

	const nativeDriver = getNativeDriver();
	const isSupported: boolean = yield call([nativeDriver, 'managementSupports'], ManagementCapability.AUTO_RECOVERY);
	if (isSupported) {
		yield bindAndTakeEveryOnlyWhenPlatform(SetDeviceAutoRecovery, setDeviceAutoRecovery, getNativeDriver);
	}
}
