import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import processCallback from '../../../Util/processCallback';
import { getAutoRecoverySetting } from './autoRecoveryTelemetrySaga';
import { IAutoRecoverySettings } from '../../../NativeDevice/IAutoRecovery';

export const deviceAutoRecoveryPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.AUTO_RECOVERY,
	Responsibility.AUTO_RECOVERY,
	ManagementCapability.AUTO_RECOVERY,
	checkAndSetAutoRecoverySettings,
);

export async function* checkAndSetAutoRecoverySettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.AUTO_RECOVERY>) {
	const autoRecoverySetting = properties.policy.value;
	const currentAutoRecoverySettings: IAutoRecoverySettings = await getAutoRecoverySetting(properties);

	if (autoRecoverySetting && autoRecoverySetting !== currentAutoRecoverySettings) {
		const finalizeCallback = await setAutoRecovery(properties, autoRecoverySetting);
		processCallback(finalizeCallback);
		return CheckAndSetResult.CHANGED;
	}

	return CheckAndSetResult.NOT_CHANGED;
}

async function setAutoRecovery(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.AUTO_RECOVERY>, autoRecoverySetting: any) {
	if (autoRecoverySetting.enabled && autoRecoverySetting.healthcheckIntervalMs) {
		return properties.managementDriver.setAutoRecovery({
			enabled: true,
			healthcheckIntervalMs: autoRecoverySetting.healthcheckIntervalMs,
		});
	} else {
		return properties.managementDriver.setAutoRecovery({
			enabled: false,
			autoEnableTimeoutMs: autoRecoverySetting.enabled === false ? autoRecoverySetting.autoEnableTimeoutMs : undefined,
		});
	}
}
