import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { getVolumeSettings } from './deviceVolumeTelemetrySagas';

export const deviceVolumePolicySaga = createDevicePolicySaga(
	DeviceSettingsType.VOLUME,
	Responsibility.VOLUME,
	ManagementCapability.SET_VOLUME,
	checkAndSetVolumeSettings,
);

export async function* checkAndSetVolumeSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.VOLUME>) {
	const volumeSettings = properties.policy.value;
	const currentVolumeSettings = await getVolumeSettings(properties);
	if (volumeSettings.volume !== currentVolumeSettings.volume) {
		await properties.managementDriver.setVolume(volumeSettings.volume);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
