import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import Responsibility from '../../../Feature/Responsibility';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';

export const telemetryAppModulesSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.APP_MODULES,
	Responsibility.APP_MODULES,
	[],
	getSettings,
);

async function getSettings({ managementDriver }: IGetTelemetryProperties): Promise<MonitoringLogData[DeviceTelemetryType.APP_MODULES]> {
	const front = await managementDriver.isFrontEnabled();
	return {
		management: true,
		front,
	};
}
